function F = eikonal( kx,x )
%Default MATLAB function name is used here, to define
%   the eikonal eq. in the format F=0;
%   input parameter: x (m)
%   used in fsolve-Matlab routine, which solves F, to find kx.
%   uses Greenwood map to relate f and x-resonance.
%   frx gives the resonance frequency at x.
%   Zcp is the CP impedance at x-resonance.
%   hd 2010-01-18
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
h=0.001; %m
rho=1000; %kg/m3
f0=20682; fcorr=140.59; %Hz
kappa=60; %m^-1
frx = f0*10^(-kappa*x) - fcorr;
omegarx = 2*pi()*frx;
omega = 2 * pi()*1750;

Zcp=0.5*(omega*1i + 50*omegarx^(1/3) - 1i* omegarx^2/omega);
Omega_h = -2i*omega*rho/Zcp;

F = kx * tanh(kx * h) - Omega_h ;
end

